<?php

/**
 * This file is part of Krizalys' OneDrive SDK for PHP.
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 *
 * @author    Christophe Vidal
 * @copyright 2008-2021 Christophe Vidal (http://www.krizalys.com)
 * @license   https://opensource.org/licenses/BSD-3-Clause 3-Clause BSD License
 * @link      https://github.com/krizalys/onedrive-php-sdk
 */

namespace Solid_Backups\Strauss\Krizalys\Onedrive\Constant;

/**
 * The special folder name.
 *
 * @since 2.4.0
 *
 * @api
 */
class SpecialFolderName
{
    /**
     * @var string
     *      The documents.
     *
     * @since 2.4.0
     *
     * @api
     */
    const DOCUMENTS = 'documents';

    /**
     * @var string
     *      The photos.
     *
     * @since 2.4.0
     *
     * @api
     */
    const PHOTOS = 'photos';

    /**
     * @var string
     *      The camera roll.
     *
     * @since 2.4.0
     *
     * @api
     */
    const CAMERA_ROLL = 'cameraroll';

    /**
     * @var string
     *      The app root.
     *
     * @since 2.4.0
     *
     * @api
     */
    const APP_ROOT = 'approot';

    /**
     * @var string
     *      The music.
     *
     * @since 2.4.0
     *
     * @api
     */
    const MUSIC = 'music';
}
